<?php

/**
 * This is the model class for table "ZlecenieOdpowiedz".
 *
 * The followings are the available columns in table 'ZlecenieOdpowiedz':
 * @property double $id
 * @property double $idZlecenia
 * @property string $odpowiedz
 */
class ZlecenieOdpowiedz extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ZlecenieOdpowiedz the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ZlecenieOdpowiedz';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idZlecenia', 'numerical'),
			array('odpowiedz', 'length', 'max'=>4000),

			array('id, idZlecenia, odpowiedz', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'zlecenieFirmies'=>array(self::HAS_MANY, 'ZlecenieFirmy', 'idOdpowiedzi'),
			'idZlecenia0'=>array(self::BELONGS_TO, 'Zlecenie', 'idZlecenia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('ZlecenieOdpowiedz', 'id'),
			'idZlecenia'=>Yii::t('ZlecenieOdpowiedz', 'idZlecenia'),
			'odpowiedz'=>Yii::t('ZlecenieOdpowiedz', 'odpowiedz'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idZlecenia', $this->idZlecenia);
		$criteria->compare('odpowiedz', $this->odpowiedz, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
